<?php require_once 'config.php'; ?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="robots" content="index, follow">
    <meta name="keywords" content="silkroad, Silkroad Online, MMORPG, Free to play, VictoriaSro, online oyun, oyun, silk, gold, SRO, Bot, f2p, hardcore mmorpg, Online game, free online mmorpg, Free game, joymax, pc game, free download, download">
    <meta name="description" content="Silkroad Online dünyanın en çok oynanan ücretsiz MMORPG oyunlarının başında gelmektedir. Silkroad Online'da eski Çin, İslam ve Avrupa medeniyetlerinin derinliklerine gidecek ve PvP, zindan sistemleri, sonsuz kale savaşları ile en iyi kahramanlardan biri olmak için çarpışacaksınız!">
    <title>VictoriaSro - Ranking</title>

    <link href="images/favicon.png" rel="shortcut icon" type="image/vnd.microsoft.icon" />

    <style>
        /* ---------- Genel ---------- */
        html, body {
            font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
            color: #ffffff;
            margin: 0;
            padding: 0;
            overflow: hidden;
            background: url('images/bg.png') 0 0 repeat;
        }

        /* ---------- Ana kapsayıcı ---------- */
        #rankmain {
            width: 800px;
            height: 569px; /* Eski haline döndürüldü */
            background: url('images/rankbg.png') 0 0 no-repeat;
            position: absolute;
            top: 0;
            left: 0;
            overflow: hidden;
        }

        /* ---------- Menü (IE uyumlu: float tabanlı) ---------- */
        #rankmain #rankmenu_container {
            width: 800px;
            height: 44px; /* Tek satır için eski yükseklik */
            /* background: url('images/menubg.png') 0 0 no-repeat; */ /* Arka plan kaldırıldı */
            margin: 5px auto 0 auto;
            overflow: hidden;
            position: relative;
        }
        
        /* Menü kaydırma butonları */
        #menu_prev, #menu_next {
            position: absolute;
            top: 5px;
            width: 20px;
            height: 34px;
            background-color: #1a1612;
            border: 1px solid #564e41;
            color: #e8cf9a;
            font-size: 20px;
            font-weight: bold;
            line-height: 34px;
            text-align: center;
            cursor: pointer;
            z-index: 10;
            font-family: Arial, sans-serif;
            overflow: hidden; /* Taşan içeriği gizle */
            box-sizing: border-box; /* Border'ı height içine dahil et */
        }
        #menu_prev { left: 3px; }
        #menu_next { right: 3px; }
        #menu_prev:hover, #menu_next:hover { background-color: #2e261e; color: #d7c791; }
        
        /* Menü wrapper - kaydırılabilir */
        #menu_wrapper {
            position: absolute;
            left: 28px; /* Sol buton genişliği + boşluk */
            width: 744px; /* 800 - 28 - 28 = 744px */
            height: 44px;
            overflow: hidden;
        }
        
        #rankmain #rankmenu_container ul {
            list-style: none;
            padding: 0;
            margin: 4px 0 0 0;
            width: 927px; /* 9×103px = 927px (9 buton, her biri 100px + 3px margin) */
            overflow: hidden;
            position: relative;
            left: 0;
            transition: left 0.3s ease;
        }
        /* 9 sekme → tek satır */
        #rankmain #rankmenu_container ul li {
            float: left;
            width: 100px; /* 110px → 100px */
            height: 34px;
            margin-right: 3px;
            background: url('images/button_nonselected.png') 0 0 no-repeat;
            background-size: 100px 34px; /* Arka plan resmini küçült */
        }
        #rankmain #rankmenu_container ul li:last-child { 
            margin-right: 0; 
        }
        #rankmain #rankmenu_container ul li.selected {
            background: url('images/button_selected.png') 0 0 no-repeat;
            background-size: 100px 34px; /* Seçili buton da küçük */
        }
        #rankmain #rankmenu_container ul li a {
            display: block;
            width: 100%;
            height: 34px;
            line-height: 34px;
            color: #8c7c63;
            text-decoration: none;
            font-size: 12px;
            text-align: center;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis; /* uzun başlıklar tek satırda kısalır */
        }
        #rankmain #rankmenu_container ul li.selected a { color: #c2e1a4; }
        #rankmain #rankmenu_container ul li a:hover { text-decoration: none; }

        /* ---------- Tablo ---------- */
        .table_rank {
            margin: 0 auto; /* Eski haline döndürüldü */
            width: 792px;
            border-top: 1px solid #564e41;
            border-left: 1px solid #564e41;
            border-right: 1px solid #564e41;
            border-collapse: collapse;
        }
        .table_rank th {
            background-color: #211c17;
            font-size: 12px;
            color: #e8cf9a;
            border-bottom: 1px solid #564e41;
            height: 24px;
        }
        .table_rank td {
            color: #8a834e;
            font-size: 12px;
            border-bottom: 1px solid #564e41;
            height: 21px;
        }

        /* Sütun genişlikleri (sayfalarla uyumlu) */
        .table_rank .th2, .table_rank .td2 { width: 70px;  text-align: center; }
        .table_rank .th3, .table_rank .td3 { width: 80px;  text-align: center; }
        .table_rank .th4, .table_rank .td4 { width: 304px; text-align: left; }
        .table_rank .th5, .table_rank .td5 { width: 96px;  text-align: center; }
        .table_rank .th6, .table_rank .td6 { width: 100px; text-align: center; }
        .table_rank .th6-char, .table_rank .td6-char { width: 100px; text-align: left; }

        /* ---------- Ortak: # sütunundaki rozet (oran bozulmaz) ---------- */
        .table_rank .td2 { white-space: nowrap; }
        .table_rank .td2 .rank-badge {
            height: 16px;   /* yalnız yükseklik; width:auto → oran korunur */
            width:  auto;
            vertical-align: middle;
            margin-right: 6px;
        }
        .table_rank .td2 .rank-no { vertical-align: middle; font-weight: 600; }

        /* ---------- Alt buton ---------- */
        #button_website {
            width: 133px;
            height: 30px;
            text-align: center;
            color: #a9985d;
            line-height: 30px;
            font-size: 12px;
            cursor: pointer;
            margin: 15px auto 0 auto; /* Eski haline döndürüldü */
            background: url(images/button_webpage.png) 0 0 no-repeat;
        }
        #button_website:hover { color: #d7c791; }
    </style>
    
    <script type="text/javascript">
        var menuPosition = 0;
        var menuItemWidth = 103; // 100px + 3px margin
        var visibleItems = 7; // Görünür sekme sayısı (artık 7 buton sığıyor)
        var totalItems = 9;
        var maxScroll = -2; // Maksimum kaydırma: -(9-7) = -2 (2 buton kaydırılabilir)
        
        function slideMenu(direction) {
            var menu = document.getElementById('rankmenu');
            if (!menu) return;
            
            if (direction === 'next' && menuPosition > maxScroll) {
                menuPosition--;
            } else if (direction === 'prev' && menuPosition < 0) {
                menuPosition++;
            }
            
            menu.style.left = (menuPosition * menuItemWidth) + 'px';
        }
        
        // Sayfa yüklendiğinde seçili sekmenin görünür olmasını sağla
        function initMenu() {
            var menu = document.getElementById('rankmenu');
            if (!menu) return;
            
            // Transition'ı geçici olarak kaldır (sayfa yüklenirken ani kaydırma için)
            menu.style.transition = 'none';
            
            var selected = menu.querySelector('li.selected');
            if (!selected) {
                menu.style.transition = 'left 0.3s ease';
                return;
            }
            
            // Seçili sekmenin index'ini bul
            var items = menu.getElementsByTagName('li');
            var selectedIndex = 0;
            for (var i = 0; i < items.length; i++) {
                if (items[i] === selected) {
                    selectedIndex = i;
                    break;
                }
            }
            
            // Menü pozisyonunu hesapla
            menuPosition = 0;
            if (selectedIndex >= visibleItems) {
                menuPosition = -(selectedIndex - visibleItems + 1);
                // Maksimum kaydırma kontrolü: En fazla 3 buton kayabilir
                if (menuPosition < maxScroll) {
                    menuPosition = maxScroll;
                }
            }
            
            // Pozisyonu ayarla
            menu.style.left = (menuPosition * menuItemWidth) + 'px';
            
            // Transition'ı geri ekle
            setTimeout(function() {
                menu.style.transition = 'left 0.3s ease';
            }, 50);
        }
        
        // IE uyumlu sayfa yükleme
        if (window.addEventListener) {
            window.addEventListener('load', initMenu);
        } else if (window.attachEvent) {
            window.attachEvent('onload', initMenu);
        }
    </script>
</head>
<body>

