<?php
require_once('adodb5/adodb.inc.php');
require_once('defines.php');
require_once('functions.php');

class db extends func
{
    private static $connectionPool = [];

    private static function connect_mssql($dbName)
    {
        $user = RDBUSER0; $pass = RDBPASS0; $host = RDBHOST0;

        if (isset(self::$connectionPool[$dbName]))
        {
            $cached = self::$connectionPool[$dbName];
            if ($cached instanceof ADOConnection)
            {
                try
                {
                    if ($cached->isConnected()) return $cached;
                }
                catch (Exception $e)
                {
                    unset(self::$connectionPool[$dbName]);
                }
            }
        }

        if (extension_loaded('sqlsrv'))
        {
            $dbo = ADONewConnection('mssqlnative');
            $dbo->setConnectionParameter('CharacterSet','UTF-8');
            $dbo->setConnectionParameter('Encrypt','No');
            $dbo->setConnectionParameter('TrustServerCertificate','Yes');
            if (@$dbo->PConnect($host, $user, $pass, $dbName))
            {
                self::$connectionPool[$dbName] = $dbo;
                return $dbo;
            }
            func::writelog("[Connection Error][mssqlnative]\t".$dbo->errorMsg(), "db_errors.log");
        }

        if (extension_loaded('odbc'))
        {
            $dsnList = [
                "Driver={ODBC Driver 18 for SQL Server};Server=$host;Database=$dbName;Encrypt=No;TrustServerCertificate=Yes;",
                "Driver={ODBC Driver 17 for SQL Server};Server=$host;Database=$dbName;Encrypt=No;TrustServerCertificate=Yes;",
                "Driver=FreeTDS;Server=$host;Port=1433;Database=$dbName;TDS_Version=7.4;ClientCharset=UTF-8;",
            ];
            foreach ($dsnList as $dsn)
            {
                $dbo = ADONewConnection('odbc_mssql');
                if (@$dbo->PConnect($dsn, $user, $pass))
                {
                    $dbo->SetFetchMode(ADODB_FETCH_BOTH);
                    self::$connectionPool[$dbName] = $dbo;
                    return $dbo;
                }
            }
            func::writelog("[Connection Error][odbc_mssql] All DSN attempts failed.", "db_errors.log");
        }

        die('Unable to connect to MSSQL: sqlsrv or ODBC driver missing/connection failed.');
    }

    public static function mssqlexec($query, $value=null, $fmode=null, $rowstoreturn=-1, $startoffset=-1)
    {
        $dbo = self::connect_mssql(RDBNAME0);
        $dbo->SetFetchMode(($fmode==null ? ADODB_FETCH_BOTH : $fmode));

        $params = null;
        if (is_array($value))
        {
            $params = $value;
        }
        elseif ($value !== null)
        {
            $params = [$value];
        }

        $trimmedQuery = ltrim($query);
        $isSelect = func::str_starts_with(strtolower($trimmedQuery), 'select');

        try
        {
            if ($isSelect)
            {
                if ($params === null)
                {
                    if ($dbq = $dbo->SelectLimit($query, $rowstoreturn, $startoffset)) return $dbq;
                }
                else
                {
                    if ($dbq = $dbo->SelectLimit($query, $rowstoreturn, $startoffset, $params)) return $dbq;
                }
            }
            else
            {
                if ($params === null)
                {
                    if ($dbq = $dbo->Execute($query)) return $dbq;
                }
                else
                {
                    if ($dbq = $dbo->Execute($query, $params)) return $dbq;
                }
            }
        }
        catch (Exception $e)
        {
            func::writelog("[Query Exception] ".$e->getMessage()." Query: ".$query, "db_errors.log");
            throw $e;
        }

        func::writelog("[Query Error]\t".$dbo->errorMsg()." Query: ".$query." Values(".($value==null ? 'null' : (is_array($value)? implode(',', $value) : $value)).")", "db_errors.log");
        die('DB query failed.');
    }
}
